import pandas as pd
import pickle

atp_tennis = pd.read_csv('atp_tennis.csv')

# Data Quality Report
missing_values = atp_tennis.isnull().sum()
unique_values = atp_tennis[['Tournament', 'Series', 'Court', 'Surface', 'Round']].nunique()

data_quality_report = pd.DataFrame({'Missing Values': missing_values, 'Unique Values': unique_values})

print(data_quality_report)
pickle.dump(data_quality_report,open("./ref_result/data_quality_report.pkl","wb"))